// DEFAULT_SETTINGS imported from shared-constants.js

// Load saved settings
document.addEventListener('DOMContentLoaded', async () => {
  // Load debugMode from chrome.storage.sync
  const syncSettings = await chrome.storage.sync.get({ debugMode: false });
  document.getElementById('debugMode').checked = syncSettings.debugMode || false;

  // Load device key from chrome.storage.local
  const localSettings = await chrome.storage.local.get({
    firebaseDeviceKey: ''
  });
  document.getElementById('firebaseDeviceKey').value = localSettings.firebaseDeviceKey || '';

  // Show status if Firebase is configured
  updateFirebaseStatus(localSettings.firebaseDeviceKey);

  // Setup save buttons
  document.getElementById('saveFirebaseBtn').addEventListener('click', saveFirebaseCredentials);
  document.getElementById('saveBtn').addEventListener('click', saveSettings);

  // Setup shortcuts button - opens Chrome's extension shortcuts page
  document.getElementById('shortcutsBtn').addEventListener('click', () => {
    chrome.tabs.create({ url: 'chrome://extensions/shortcuts' });
  });
});

function updateFirebaseStatus(deviceKey) {
  const statusEl = document.getElementById('firebaseStatus');
  if (deviceKey) {
    statusEl.textContent = '✓ Connected - entries will be saved to cloud';
    statusEl.className = 'status success';
    statusEl.style.display = 'block';
  } else {
    statusEl.style.display = 'none';
  }
}

async function saveFirebaseCredentials() {
  const deviceKey = document.getElementById('firebaseDeviceKey').value.trim();
  const statusEl = document.getElementById('firebaseStatus');

  await chrome.storage.local.set({
    firebaseDeviceKey: deviceKey
  });

  // Show success message
  if (deviceKey) {
    statusEl.textContent = 'Device key saved!';
    statusEl.className = 'status success';
    statusEl.style.display = 'block';
    setTimeout(() => updateFirebaseStatus(deviceKey), 2000);
  } else {
    updateFirebaseStatus(deviceKey);
  }
}

async function saveSettings() {
  const debugMode = document.getElementById('debugMode').checked;
  const statusEl = document.getElementById('status');

  // Save debugMode to chrome.storage.sync
  await chrome.storage.sync.set({ debugMode: debugMode });

  // Save Firebase credentials
  await saveFirebaseCredentials();

  // Show success message
  statusEl.textContent = 'Settings saved successfully!';
  statusEl.className = 'status success';
  statusEl.style.display = 'block';

  // Hide after 2 seconds
  setTimeout(() => {
    statusEl.style.display = 'none';
  }, 2000);
}
